<?=$this->extend('layouts/main')?>

<?=$this->section('content')?>
	<section class="slider-wrapper">
		<video class="video-bg" autoplay nocontrols loop muted>
			<source src="/videos/solar-assessment-desktop.mp4" type="video/mp4">
		</video>
		<img class="image-bg" src="/images/carousel-thumbnail-1.jpg">
		<img class="image-bg2" src="/images/carousel-thumbnail-2.jpg">
		</img>
		<div class="slider">
			<div class="items item-1 pt-5 ps-5">
				<div class="row pt-5">
					
					<div class="col-md-6 col-sm-2">
						<h1 class="display-3 fw-bold">
							Start Today, Run Your Home by the Sun
						</h1>
						<div class="item1-description lead">Contact us and we'll look for the best solution for home solar.</div>
						<!-- <a href="#form-section" type="button" class="btn btn-info btn-rounded main-button scroll-smooth">
							Get Started
						</a> -->
					</div>
					<div class="col-md-3 col-sm-2 offset-md-1 text-center get-started">
						<form action="#" method="post" enctype="multipart/form-data">
						<div class="form-group">
							<p class="fs-4 fw-bold">Get a free<br>solar quote</p>
							<input type="text" class="form-control get-zip zipcode" name="zipcode" placeholder="Enter Zip Code" required="">
						</div>
						<a type="submit" href="#form-section" class="button btn btn-default zipClick text-white">Get Started</a>
						</form>
					</div>
				</div>

			</div>
			<div class="items item-2 pt-5 ps-5">
				<div class="row pt-5">
					<h1 class="display-3 fw-bold col-12">
						Did you know solar can save you an average of $26,000 on electricity costs over 20 years?
					</h1>
					<div class="item1-description lead col-12">Click below to find out why and learn the answers to your biggest solar questions.</div>
					<div  class="col-md-8 col-sm-2">
						<a href="#whysolar" type="button" class="btn btn-info btn-rounded main-button scroll-smooth">
						Learn how
						</a>
					</div>
				</div>
			</div>
			<div class="items item-3 pt-5 ps-5">
				<div class="row pt-5">
					<h1 class="display-3 fw-bold col-12">
						Find Out How Much Their Life has Changed
					</h1>
					<div class="item1-description lead col-12">Real Lives. Real Stories.</div>
					<div  class="col-md-8 col-sm-2">
						<a href="#stories-section" type="button" class="btn btn-info btn-rounded main-button scroll-smooth">
							See the Stories
						</a>
					</div>
				</div>
			</div>
			<div class="items item-4 pt-5 ps-5">
				<div class="row pt-5">
					<h1 class="display-3 fw-bold col-12">
						The Solar Pro FAQ
					</h1>
					<div class="item1-description lead col-12">Learn the answers to the biggest questions about solar.</div>
					<div  class="col-md-8 col-sm-2">
						<a href="#faq-section" type="button" class="btn btn-info btn-rounded main-button scroll-smooth">
						Start Watching
						</a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<div class="d-flex p-5 flex-column bd-highlight color-bg" id="whysolar">
		<div class="d-flex justify-content-center">
			<h5>How will you take your Power back</h5>
		</div>
		<div class="d-flex justify-content-center">
			<h2>Solar Pro delivers home energy solutions that save you money and lower your carbon footprint. What will you do with the results?</h2>
		</div>
		<div class="d-flex justify-content-center row">
			<div class="card counter col-sm-3 gx-2" style="background-image: url(images/counter-bg-co2.jpg)">
				<div class="card-body">
					<div class="gradient-background"></div>
					<h4 class="card-head card-bottom-line">Est. Carbon Sequestered</h4>
					<div class="container">
						<div class="row">
							<div class="tick" data-value="442380650" data-did-init="sequestered">

								<div data-value-mapping="indexes" data-layout="horizontal fit" data-transform="arrive(.2) -> round -> split -> delay(rtl, 100, 150)">
									<span data-view="flip">4</span>
									<span data-view="flip">4</span>
									<span data-view="flip">2</span>
									<span class="tick-text-inline">,</span>
									<span data-view="flip">3</span>
									<span data-view="flip">8</span>
									<span data-view="flip">0</span>
									<span class="tick-text-inline">,</span>
									<span data-view="flip">6</span>
									<span data-view="flip">5</span>
									<span data-view="flip">0</span>
								</div>
							</div>
						</div>
					</div>
					<div class="container">
						<div class="row">
							<div class="col-sm-12 bottom-card-counter-text">
								<div class="float-end">
									<p class="font-weight-bold text-uppercase">lbs</p>
								</div>
							</div>
						</div>
					</div>

				</div>

			</div>
			<div class="card counter col-sm-3 gx-2" style="background-image: url(images/counter-bg-usd.jpg)">
				<div class="card-body">
				<div class="gradient-background"></div>
					<h4 class="card-head card-bottom-line">Est. Savings From Solar Customers</h4>
					<div class="container">
						<div class="row">
							<div class="tick" data-value="6325569" data-did-init="savings">

								<div data-value-mapping="indexes" data-layout="horizontal fit" data-transform="arrive(.2) -> round -> split -> delay(rtl, 100, 150)">

									<span class="tick-text-inline">$</span>

									<span data-view="flip">6</span>
									<span class="tick-text-inline">,</span>
									<span data-view="flip">3</span>
									<span data-view="flip">2</span>
									<span data-view="flip">5</span>
									<span class="tick-text-inline">,</span>
									<span data-view="flip">5</span>
									<span data-view="flip">6</span>
									<span data-view="flip">9</span>
								</div>

							</div>
						</div>
					</div>
					<div class="container">
						<div class="row">
							<div class="col-sm-12 bottom-card-counter-text">
								<div class="float-end">
									<p class="font-weight-bold text-uppercase">US Dollars</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="card counter col-sm-3 gx-2" style="background-image: url(images/counter-bg-kwh.jpg)">
				<div class="card-body">
					<div class="gradient-background"></div>
					<h4 class="card-head card-bottom-line">Est. KWH Produced</h4>
					<div class="container">
						<div class="row">
							<div class="tick" data-value="125685352" data-did-init="kwhproduced">

								<div data-value-mapping="indexes" data-layout="horizontal fit" data-transform="arrive(.2) -> round -> split -> delay(rtl, 100, 150)">
									<span data-view="flip">1</span>
									<span data-view="flip">2</span>
									<span data-view="flip">5</span>
									<span class="tick-text-inline">,</span>
									<span data-view="flip">6</span>
									<span data-view="flip">8</span>
									<span data-view="flip">5</span>
									<span class="tick-text-inline">,</span>
									<span data-view="flip">3</span>
									<span data-view="flip">5</span>
									<span data-view="flip">2</span>
								</div>
							</div>
						</div>
					</div>
					<div class="container">
						<div class="row">
							<div class="col-sm-12 bottom-card-counter-text">
								<div class="float-end">
									<p class="font-weight-bold text-uppercase">Killowatt-hours</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="d-flex justify-content-center py-5">
			<h5>How Solar Panel Works</h5>
		</div>
		<div class="d-flex justify-content-center">
			<h2>Solar panels work by converting the sun’s energy into usable electricity for your home. Any power that is unused will flow back through your power meter to the grid, which will be delivered back to your home when the sun goes down. This process is called “Net Metering” and it works to save you money by minimizing the need to buy power from your utility company.</h2>
		</div>
		<div class="d-flex justify-content-center">
			<div class="col-lg-6">
				<img src="/images/01_daytonight-1 (1).gif" class="w-100" />
			</div>
		</div>
	</div>
	<div class="container-fluid mx-0 px-0 color-bg">
		<div class="row mb-5 bg-dark-blue" id="solarpanel">
			<div class="container">
				<div class="row text-center d-flex justify-content-center py-5">
					<div class='col-12'>
						<div class="container">
							<div class="row">
								<div class='col-12'>
									<h1 class="text-center text-white fs-2">Solar Panel</ph1>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-lg-7 col-md-12 bg-image hover-zoom order-1 order-md-1 order-lg-2 ">
				<img src="/images/solar_panel.jpg" class="w-100" />
			</div>
			<div class="col-lg-5 col-md-12 py-5 mt-5 order-2 order-md-2 order-lg-1">
				<div class="container-fluid pt-5">
					<h4 class="card-head card-bottom-line">Design and Specs</h4>
					<h3 class="fs-3">Sleek and Durable.</h3>
					<h3 class="fs-6 p-2">
						Our solar panels are low-profile and durable — quietly converting sunlight to energy for decades to come. Integrated hardware and simple design achieve this by securing the panels close to your roof and to each other for a minimal aesthetic
					</h3>
					<div class="row">
						<div class="col-6">
							<div class="container pt-5">
								<div class="row">
									<div class="col-12 before-underlines">
										<p class="fw-bold">Wattage</p>
										<p class="fw-normal">340 W</p>
									</div>
								</div>
								<div class="row">
									<div class="col-12 before-underlines">
										<p class="fw-bold">Operating Temperature</p>
										<p class="fw-normal">-40°F up to +185°F</p>
									</div>
								</div>
								<div class="row">
									<div class="col-12 before-underlines">
										<p class="fw-bold">Dimensions</p>
										<p class="fw-normal">
											68.5" x 40.6" x 1.57"</br>
											(including frame)
										</p>
									</div>
								</div>
								<div class="row">
									<div class="col-12 before-underlines">
										<p class="fw-bold">Frame Type</p>
										<p class="fw-normal">Black anodized aluminum</p>
									</div>
								</div>
								<div class="row">
									<div class="col-6 before-underlines">
										<p class="fw-bold">Warranty</p>
										<p class="fw-normal">25 year performance guarantee</p>
									</div>
								</div>
							</div>
						</div>
						<div class="col-6">
							<div class="container pt-5">
								<div class="row">
									<div class="col-12 before-underlines">
										<p class="fw-bold">Certifications</p>
										<p class="fw-normal">
											UL 1703, CE-Compliant,</br>
											IEC 61215 (Ed. 2),</br>
											IEC 61730 (Ed. 1)
										</p>
									</div>
								</div>
								<div class="row">
									<div class="col-12 before-underlines">
										<p class="fw-bold">Inverter Power</p>
										<p class="fw-normal">
											3.8kW / 7.6kW</br>
											97.5% efficiency
										</p>
									</div>
								</div>
								<div class="row">
									<div class="col-12 before-underlines">
										<p class="fw-bold">Inverter Dimensions</p>
										<p class="fw-normal">26" x 16" x 6"</p>
									</div>
								</div>
								<div class="row">
									<div class="col-6 before-underlines">
										<p class="fw-bold">Inverter Warranty</p>
										<p class="fw-normal">12.5 years</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
		<div class="row mt-5">
			
			<div class="col-lg-7 col-md-12 bg-image hover-zoom">
				<img src="/images/PW-Inverter-Hero-D.jpg" class="w-100 h-100" />
			</div>
			<div class="col-lg-5 col-md-12 py-5 d-flex align-items-center">
				<div class="container-fluid">
					<div class="row">
						<div class="col-12">
							<h4 class="card-head card-bottom-line">Powerwall</h4>
							<h3 class="fs-3">Backup Protection</h3>
							<h3 class="fs-6 p-2">
								Powerwall is a compact home battery that is bundled with every Tesla solar purchase. It stores the energy you produce with Solar Roof, making it available anytime—at night or during an outage.
							</h3>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-5 bg-dark-blue text-white">
			<div class="col-lg-5 col-md-12 py-5 order-2 order-md-2 order-lg-1">
				<div class="container-fluid">
					<div class="row">
						<div class="col-12">
							<h4 class="card-head card-bottom-line">The Power Process</h4>
							<h3 class="fs-3">It's a simple process that only requires your utility bill to get started.</h3>
							<ul class="fs-6 p-2">
								<li class="p-2 d-flex marker-steps" id="step1">Collect Your Energy Bill</li>
								<li class="p-2 d-flex marker-steps" id="step2">Review a Custom Proposal</li>
								<li class="p-2 d-flex marker-steps" id="step3">Select the Best Plan</li>
								<li class="p-2 d-flex marker-steps" id="step4">Sign Proposal</li>
								<li class="p-2 d-flex marker-steps" id="step5">Get Started</li>
							</ul>
						</div>
					</div>
					<div class="row pb-2">
						<div class="col-6 col-md-3">
							<a href="#form-section" type="button" class="btn btn-info btn-rounded main-button scroll-smooth">
								Get Started
							</a>
						</div>
					</div>

					
					<div class="row pt-1">
						
						<div class="col-md-3 col-6 pb-5 mb-5">
							<div class="card shadow-0">
								<div class="bg-image hover-zoom">
									<img src="/images/whysolar_UtilityBill.jpg" class="img-fluid " />
								</div>
								<div class="card-body text-black bg-transparent card-body-overlap-3">
									<h5 class="card-title lead">Collect Utility Bill</h5>
								</div>
							</div>
						</div>

						<div class="col-md-3 col-6 pb-5 mb-5">
							<div class="card shadow-0">
								<div class="bg-image hover-zoom">
									<img src="/images/whysolar_ReviewProposal.jpg" class="img-fluid" />
								</div>
								<div class="card-body text-black bg-transparent card-body-overlap-3">
									<h5 class="card-title lead">Review Your Proposal</h5>
								</div>
							</div>
						</div>
						
						<div class="col-md-3 col-6 pb-5 mb-5">
							<div class="card shadow-0">
								<div class="bg-image hover-zoom">
									<img src="/images/whysolar_SelectBest.jpg" class="img-fluid " />
								</div>
								<div class="card-body text-black bg-transparent card-body-overlap-3">
									<h5 class="card-title lead">Select Best Option</h5>
								</div>
							</div>
						</div>

						<div class="col-md-3 col-6 pb-5 mb-5">
							<div class="card shadow-0">
								<div class="bg-image hover-zoom">
									<img src="/images/whysolar_ScheduleInstall.jpg" class="img-fluid " />
								</div>
								<div class="card-body text-black bg-transparent card-body-overlap-3">
									<h5 class="card-title lead">Get Started</h5>
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
			<div class="col-lg-7 col-md-12 order-1 order-md-1 order-lg-2 bg-image hover-zoom">
				<img src="/images/home_ConsultantWithHomeowner.jpg" class="w-100 h-100" />
			</div>
		</div>
		<div class="row mt-5">
			<div class="col-lg-7 col-md-12">
			<video class="w-100" autoplay nocontrols loop muted>
				<source src="/videos/save.mp4" type="video/mp4">
			</video>
			</div>
			<div class="col-lg-5 col-md-12 mt-5 py-5">
				<div class="container-fluid pt-5 h-100 savings-box d-flex align-items-center">
					<div class="row">

						<div class="col-12">
							<h4 class="card-head card-bottom-line">Savings</h4>
							<h3 class="fs-3">Electricity For Less</h3>
							<h3 class="fs-6 p-2">
								Use solar energy to power your home and reduce your dependence on the grid. Purchase solar at the lowest price of any national provider and take control of your monthly electricity bill. 
							</h3>
						</div>
						<div class="col-12 pt-5">
							<div class="container-fluid pt-5">
								<div class="row">
									
									<div class="col-lg-12 col-8 d-flex align-items-center">
										<div style="margin:auto;" class="">
											<img src="/images/zerodown.png" class="img-fluid" />
										</div>
									</div>
									
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</div>
		<div class="row mt-5 bg-dark-blue">
			<div class="col-lg-5 col-md-12 mt-5 order-2 order-md-2 order-lg-1 d-flex align-items-center">
				<div class="container-fluid ">
					<div class="row">
						<div class="col-12">
							<h4 class="fs-2 text-white">Take Control over Rising Energy Costs.</h4>
						</div>
						<div class="col-12">
							<a href="#form-section" type="button" class="btn btn-info btn-rounded main-button scroll-smooth">
								Get Started
							</a>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-7 col-md-12 order-1 order-md-1 order-lg-2 bg-image hover-zoom">
				<img src="/images/solar-company-desktop-d.jpg" class="w-100" />
			</div>
		</div>
		<div class="row bg-dark-blue">
			<div class="container">
				<div class="row text-center d-flex justify-content-center py-5">
					<div class='col-3'>
						<div class="container">
							<div class="row">
								<div class='col-12'>
									<p class="text-center text-white">"Solar Pro lets people add solar to homes with no upfront costs"</p>
								</div>
							</div>
						</div>
					</div>
					<div class='col-3 '>
						<div class="container">
							<div class="row d-flex justify-content-center">
								<div class='col-12'>
									<p class="text-center text-white">"Solar Pro will help you save money day one"</p>
								</div>
							</div>
						</div>
					</div>
					<div class='col-3 '>
						<div class="container">
							<div class="row d-flex justify-content-center">
								<div class='col-12'>
									<p class="text-center text-white">"Solar Pro provides clean, reliable energy at significantly lower costs"</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row bg-dark-blue" id="stories-section">
			<div class="container">
				<div class="row text-center d-flex justify-content-center py-5">
					<div class='col-12'>
						<div class="container">
							<div class="row">
								<div class='col-12'>
									<h1 class="text-center text-white fs-2">Testimonials</ph1>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row d-flex justify-content-center py-5" >
			<div class="col-12 d-flex justify-content-center pt-5">
				<h5>Millions of reasons. One mission.</h5>
			</div>
			<div class="col-12 d-flex justify-content-center">
				<h2>Every homeowner has their own reason they've ditched their utility and gone solar. Hear their stories.</h2>
			</div>
			<div class="col-12 d-flex justify-content-center">
				<div class="container">
					<div class="row d-flex justify-content-center">
						<div class="col-12 col-md-4 my-2" role="button"  data-mdb-toggle="modal" data-mdb-target="#testimonymodal1" data-theVideo="/videos/Amish_Puja_Homeowner_website_v3_11.mp4">
							<div class="card text-center shadow-0 card-bg-none">
								<div class="bg-image hover-zoom card-images">
									<img src="/images/homeowner-testimonial-1.png" class="img-fluid " />
									<a href="#!">
									<div class="mask" style="background-color: rgba(251, 251, 251, 0.15)"></div>
									</a>
								</div>

								<div class="card-body card-body-overlap bg-white mx-auto shadow-1 rounded">
									<h5 class="card-title">The Better Way</h5>
									<p class="card-text">
										Find out how Solar Pro helped these home entrepreneurs save money and live their lives.
									</p>
								</div>
							</div>
						</div>
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#testimonymodal2" data-theVideo="/videos/JohnParis_Homeowner_website_v3_11.mp4">
							<div class="card text-center shadow-0 card-bg-none">
								<div class="bg-image hover-zoom card-images">
									<img src="/images/homeowner-testimonial-2.png" class="img-fluid" />
									<a href="#!">
									<div class="mask" style="background-color: rgba(251, 251, 251, 0.15)"></div>
									</a>
								</div>

								<div class="card-body card-body-overlap bg-white mx-auto shadow-1 rounded">
									<h5 class="card-title">Energy and Independence</h5>
									<p class="card-text">
										Watch how this Solar Pro customer got his independence back from his utility.
									</p>
								</div>
							</div>
						</div>
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#testimonymodal3" data-theVideo="/videos/Kristy_Homeowner_website_v3_11.mp4">
							<div class="card text-center shadow-0 card-bg-none">
								<div class="bg-image hover-zoom card-images">
									<img src="/images/homeowner-testimonial-3.png" class="img-fluid" />
									<a href="#!">
									<div class="mask" style="background-color: rgba(251, 251, 251, 0.15)"></div>
									</a>
								</div>

								<div class="card-body card-body-overlap bg-white mx-auto shadow-1 rounded" id="serviceyoutrust">
									<h5 class="card-title">Services you trust</h5>
									<p class="card-text">
										See why Solar Pro consultants go above and beyond the norm.
									</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-5 bg-dark-blue" id="form-section">
			<div class="container">
				<div class="row text-center d-flex justify-content-center py-5">
					<div class='col-12'>
						<div class="container">
							<div class="row">
								<div class='col-12'>
									<h1 class="text-center text-white fs-2">Get Your Quote Now</ph1>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-5 dark-bg" >
			<div class="col-lg-7 col-md-12 bg-image hover-zoom">
				<img src="/images/sp_hero_d.jpg" class="w-100" />
			</div>
			<div class="col-lg-5 col-md-12 py-2 mt-5">
				<div class="container-fluid pt-5">
					<div class="row d-flex justify-content-center ">
						<div class="col-10 shadow-5 rounded bg-white">
							<form method="POST" action="home/saveform" class="py-5">
								<!-- 2 column grid layout with text inputs for the first and last names -->
								<div class="row mb-4">
									<div class="col">
										<div class="form-outline">
											<input type="text" id="first_name" class="form-control" name="first_name" required/>
											<label class="form-label" for="first_name">First name</label>
										</div>
									</div>
									<div class="col">
										<div class="form-outline">
											<input type="text" id="last_name" class="form-control"  name="last_name" required/>
											<label class="form-label" for="last_name">Last name</label>
										</div>
									</div>
								</div>

								<!-- Email input -->
								<div class="form-outline mb-4">
									<input type="email" id="email" class="form-control" name="email" required/>
									<label class="form-label" for="email">Email address</label>
								</div>

								<div class="row mb-4">
									<div class="col">
										<div class="form-outline">
											<input type="number" id="zip" class="form-control" name="zip" required/>
											<label class="form-label" for="zip">Zip Code</label>
										</div>
									</div>
									<div class="col">
										<div class="form-outline">
											<input type="tel" id="mobile" class="form-control" name="mobile" required/>
											<label class="form-label" for="mobile">Phone</label>
										</div>
									</div>
								</div>
								<div class="row">
								<label class="form-label" >Do you own your home?</label>
								</div>
								<div class="form-check form-check-inline mb-4">
									<input class="form-check-input" type="radio" value="1" name="homeowner" id="homeown1" required/>
									<label class="form-check-label" for="homeown1">Yes</label>
								</div>
								<div class="form-check form-check-inline mb-4">
									<input class="form-check-input" type="radio" value="0" name="homeowner" id="homeown2" />
									<label class="form-check-label" for="homeown2">No</label>
								</div>
								<!-- Checkbox -->
								<div class="form-check mb-4 d-flex">
									<input class="form-check-input me-2 d-flex" type="checkbox" value="1" id="referred" name="referral"/>
									<label class="form-check-label d-flex" for="referred">
										I was referred to Solar Pro by a friend or family member 
									</label>
								</div>
								<p class="term-of-service-text">By clicking below, I authorize Solar Pro to call me and send pre-recorded messages and text messages to me about Solar Pro products and services at the telephone number I entered above, using an autodialer, even if I am on a national or state “Do Not Call” list. Message and data rates may apply. Maximum 10 texts per month. Consent for calls & texts is optional. You can opt out anytime. You also agree to our Terms of Service.</p>
								<!-- Submit button -->
								<button type="submit" class="btn btn-primary btn-block mb-4 main-button">
									See if you qualify
								</button>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-5 bg-dark-blue" id="faq-section">
			<div class="container">
				<div class="row text-center d-flex justify-content-center py-5">
					<div class='col-12'>
						<div class="container">
							<div class="row">
								<div class='col-12'>
									<h1 class="text-center text-white fs-2">The Ultimate Solar FAQ</ph1>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row mt-5">
			<div class="col-12 d-flex justify-content-center">
				<div class="container py-5">
					<div class="row d-flex justify-content-center py-2">
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#faqModal1">
							<div class="card shadow-0 ">
								<div class="bg-image hover-zoom">
									<img src="/images/images (2).jpg" class="img faq-height" />
									<a href="#!">
									<div class="gradient-background-card" ></div>
									</a>
								</div>
								<div class="card-body text-white bg-transparent card-body-overlap-2">
									<h5 class="card-title">What is Net Metering?</h5>
								</div>
							</div>
						</div>
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#faqModal2" data-theVideo="/videos/FilmForth QTTrim 2021_07_13_13_15_36.mp4">
							<div class="card shadow-0 ">
								<div class="bg-image hover-zoom">
									<img src="/images/images.png" class="img faq-height" />
									<a href="#!">
									<div class="gradient-background-card" ></div>
									</a>
								</div>
								<div class="card-body text-white bg-transparent card-body-overlap-2">
									<h5 class="card-title">Understanding Solar Investment Tax Credit</h5>
								</div>
							</div>
						</div>
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#faqModal3" data-theVideo="https://www.youtube.com/embed/W2MpGCL8-9o">
							<div class="card shadow-0 ">
								<div class="bg-image hover-zoom">
									<img src="/images/stucco-repair-warranty.png" class="img faq-height" />
									<a href="#!">
									<div class="gradient-background-card" ></div>
									</a>
								</div>
								<div class="card-body text-white bg-transparent card-body-overlap-2">
									<h5 class="card-title">Navigating Solar Warranties</h5>
								</div>
							</div>
						</div>
					</div>

					<div class="row d-flex justify-content-center py-2">
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#faqModal4" data-theVideo="https://www.youtube.com/embed/W2MpGCL8-9o">
							<div class="card shadow-0 ">
								<div class="bg-image hover-zoom">
									<img src="/images/C19D7A6E1D36CBC687CCC05CB793A6A0.jpg" class="img faq-height" />
									<a href="#!">
									<div class="gradient-background-card" ></div>
									</a>
								</div>
								<div class="card-body text-white bg-transparent card-body-overlap-2">
									<h5 class="card-title">Is Solar a Good Investment for My Family?</h5>
								</div>
							</div>
						</div>
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#faqModal5" data-theVideo="https://www.youtube.com/embed/W2MpGCL8-9o">
							<div class="card shadow-0 ">
								<div class="bg-image hover-zoom">
									<img src="/images/How to Become a Solar Energy Consultant.jpg" class="img faq-height" />
									<a href="#!">
									<div class="gradient-background-card" ></div>
									</a>
								</div>
								<div class="card-body text-white bg-transparent card-body-overlap-2">
									<h5 class="card-title">How to Determine a Solar Fit for My House?</h5>
								</div>
							</div>
						</div>
						<div class="col-12 col-md-4 my-2" role="button" data-mdb-toggle="modal" data-mdb-target="#faqModal6" data-theVideo="https://www.youtube.com/embed/W2MpGCL8-9o">
							<div class="card shadow-0 ">
								<div class="bg-image hover-zoom">
									<img src="/images/POWER-YOUR-HOME-WITH-SOLAR-POWER-PRODUCTS-nxenhm4vd852lyvsmro1l4wqh04wyu79vqfuhpvatw.webp" class="img faq-height" />
									<a href="#!">
									<div class="gradient-background-card" ></div>
									</a>
								</div>
								<div class="card-body text-white bg-transparent card-body-overlap-2">
									<h5 class="card-title">Can Solar Be Too Expensive?</h5>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<!-- MODALS -->

	<div class="modal fade" id="faqModal1" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">The Better Way</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
				<div class="container p-4">
					<div class="row">
						<div class="col-12">
							<p class="lead">Net metering is the policy that really enables your solar to work for you. In most US states, there is a policy that says for every kilowatt hour that you put into the grid, you will receive a credit for that kilowatt hour. So if your solar system produces 10 kilowatt hours of energy, and it puts those 10 kilowatt hours into the grid, that's 10 kilowatt hours you get back. That's what net metering is.</p>
							<p class="lead">This is really important because your solar system produces energy during the daytime, but you use energy during the nighttime as well. How it works is that during the daytime, you put a lot of energy into the grid, and it goes “on account” to be used later when you are not producing electricity. So you're banking all those credits. Then at night (or on a cloudy day), you pull that energy off the grid, and you use all the credits you accumulated.</p>
							<p class="lead">That's net metering. It's an amazing policy. One that we all as consumers and advocates for clean energy have to continue to fight for. It has enabled solar to develop so much and, in effect, gives you the ability to use the grid as your own battery, reducing the cost of electricity for you and your family.</p>
						</div>
					</div>
				</div>

          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="faqModal2" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Understanding Solar Investment Tax Credit</h5>
				<a type="button" class="btn-close btn-close-white"  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
				<div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
					<iframe class="embed-responsive-item" src="" allowfullscreen controls></iframe>
				</div>
          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="faqModal3" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Navigating Solar Warranties</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
			  <div class="container p-4">
					<div class="row">
						<div class="col-12">
							<p class="lead">One of the most common questions our clients ask is how a solar warranty works. There are three types of solar warranties:</p>
							<p class="lead">Net metering is the policy that really enables your solar to work for you. In most US states, there is a policy that says for every kilowatt hour that you put into the grid, you will receive a credit for that kilowatt hour. So if your solar system produces 10 kilowatt hours of energy, and it puts those 10 kilowatt hours into the grid, that's 10 kilowatt hours you get back. That's what net metering is.</p>
							<p class="lead">The first one is on the panels. When you buy a solar system for power, those panels are typically warrantied for 25 years. What that means is they're guaranteed to work for 25 years and continue to produce power. Now, depending on the panel you buy, that production guarantee could be anywhere from 85% of the power they were producing on day one, all the way up to 92% if you opt for a higher-efficiency, premium panel.</p>
							<p class="lead">The second type of warranty is on your inverter, which is the component of your system that transforms the energy you get directly from the sun into usable AC current that can actually power your home: turn on your lights, power your A/C, help you watch TV and all that good stuff. Your inverter is warrantied anywhere from 12 to 25 years. And a lot of times we will also include an extended option for 30 years, which really makes it a complete no-brainer.</p>
							<p class="lead">Now the third part of the warranty covers what's called the workmanship. Our workmanship warranty is for 10 years. That means all the work that we do on your house when we're installing your solar system, when we're on your roof while you're working, when we're working inside your electrical panel. All of that work is guaranteed for 10 years to make sure that there's absolutely no issues.</p>
							<p class="lead">25 years on the panels, 12 to 30 years on the inverter, 10 years on the workmanship warranty. Truly, we've got you covered when it comes to protecting your solar investment and making sure that it provides value to you for the long haul.</p>
						</div>
					</div>
				</div>

          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="faqModal4" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Is Solar a Good Investment for My Family?</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
				<div class="container p-4">
					<div class="row">
						<div class="col-12">
							<p class="lead">It is well-documented that solar increases the value of your home. The reason for this is that it's a home investment that actually produces income. A solar system sits on your roof and generates electricity, and there is a value for each kilowatt of electricity your system produces.</p>
							<p class="lead">In fact, each KW you produce is a KW that you don’t have to purchase from your electric company. Plus the future value of all of those savings is valuable to the next buyer of your home.</p>
							<p class="lead">Another amazing reason to go solar today - get the economic benefits today, and get more for the sale of your home tomorrow.</p>
						</div>
					</div>
				</div>

          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="faqModal5" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">How to Determine a Solar Fit for My House?</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
			  <div class="container p-4">
					<div class="row">
						<div class="col-12">
							<p class="lead">Not every home is eligible for solar, so cross your fingers. Let's hope you're one of the lucky ones, and you can save money. There are three main factors:</p>
							<p class="lead">Number one is called "sun exposure" - does your roof (or the location of your solar panels) get enough access to the sun? One of the things we'll do is analyze your sun exposure from satellite images and other technology to make sure that you've got what's called "proper solar access". There's a percentage we're looking for which, as long as you’ve got that, you're good to go.</p>
							<p class="lead">Number two is orientation. What direction would your panels be facing? Ideally we would want the panels facing South or West, since that is where the most sunshine hits. So you're looking for the right sun exposure, you're looking for the right orientation.</p>
							<p class="lead">And then there's just number three. Are there any structural issues with your house or roof that would make it difficult to mount solar panels? And if it turns out that it doesn't work for solar, no harm done, you got educated and you know it is what it is. But that's the reason why I encourage you to reach out and get a no-cost proposal from us so we can actually do the hard work of analyzing your property and show you exactly how much money you can save by going solar.</p>
						</div>
					</div>
				</div>

          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="faqModal6" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Can Solar Be Too Expensive?</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
			  <div class="container p-4">
					<div class="row">
						<div class="col-12">
							<p class="lead">One of the biggest questions that everybody has about solar is "How do I pay for it?" The old misconception was that it actually took cash to go solar. People thought, well, solar is expensive, because I have to spend this upfront cash. That could not be further from the truth.</p>
							<p class="lead">Today, in fact, solar is the least expensive option to get energy in most of the United States. And with low interest rates and lots of finance programs, it is typically easy for most homeowners to get zero-down financing. There are two primary ways to finance your solar system today: with a low interest rate loan or a lease. Let's talk about both options.</p>
							<p class="lead">A zero down loan means that you can choose a loan term, whether it's five years, 10 years, 15 years, 20 years, or 25 years. We offer all of those, and we offer them at the most competitive rates possible. Now, when you go solar with a zero down loan, what that means is, you finance the system through your loan provider, and instead of paying a monthly bill to your utility, you simply pay a less expensive monthly payment to your loan provider. So you get to keep the difference.</p>
							<p class="lead">If, for some reason, a person can't get a loan, they will often choose a lease. This may be because they don't have a tax liability and can't keep the tax credit. A lease is exactly like it sounds - every single month, you'll pay a lease payment. And you'll pay that usually over 20 years. It's that simple. Your lease payment is going to be less than what you used to pay your utility bill, which means you're saving money every single month.</p>
							<p class="lead">We will help you figure out what is best for you. When you get a proposal from us, our consultants are going to sit down with you. They're going to show you all the different options and help you decide what's best for you. They're going to show you how much money you can save with Powur and we're going to make it as easy as humanly possible for you to understand and make your decision.</p>
						</div>
					</div>
				</div>

          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="testimonymodal1" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">The Better Way</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
				<div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
				<iframe class="embed-responsive-item" src="" allowfullscreen controls></iframe>
				</div>

          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="testimonymodal2" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Energy and Independence</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
				<div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
				<iframe class="embed-responsive-item" src="" allowfullscreen controls></iframe>
				</div>

          	</div>
        </div>

      </div>
    </div>

	<div class="modal fade" id="testimonymodal3" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">

        <div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Services you trust</h5>
				<a type="button" class="btn-close btn-close-white "  data-mdb-dismiss="modal"  aria-label="Close" ></a>
			</div>
          	<div class="modal-body mb-0 p-0">
				<div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
				<iframe class="embed-responsive-item" src="" allowfullscreen controls></iframe>
				</div>

          	</div>
        </div>

      </div>
    </div>
<?=$this->endSection()?>