<?php

namespace App\Controllers;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
class Selector extends BaseController
{
    public function index()
    {  
        $user_id = $this->request->getGET("id");
        $data = ['user_id'=>$user_id];
        $db = \Config\Database::connect();
        $builder = $db->table('user');
        $usercount = $builder->where('id', $user_id)->countAllResults();
        if($user_id == null || $usercount != 1){
            return redirect()->to(base_url());
        }
        return view('selector',$data);
    }
    public function save_user(){
        $db = \Config\Database::connect();
      
        $builder = $db->table('userdata');
        $user = $db->table('user');
        $user_id = $this->request->getPost("user_id");
        $homeown = $this->request->getPost("homeown");
        $address = $this->request->getPost("address");
        $home_size = $this->request->getPost("home_size");
        $home_type = $this->request->getPost("home-type");
        $solarpanel = $this->request->getPost("solarpanel");
        $roof_pitch = $this->request->getPost("roof_pitch");
        $roof_type = $this->request->getPost("roof_type");

        $electric_bill = $this->request->getPost("electric_bill");
        $appliances =$this->request->getPost("appliances");
        $household = $this->request->getPost("household");
        $household_size_next = $this->request->getPost("household_size_next");
        $backup = $this->request->getPost("backup");

        $know_more = $this->request->getPost("purchase");
        $creditscore = $this->request->getPost("creditscore");

        if($solarpanel == 'no'){
            $solarpanel = 0;
            $solartext = "Does not Own";
        }else{
            $solarpanel = 1;
            $solartext = "Own a Solar Panel";
        }
        if($appliances != null){
            $appliances = implode(',',$this->request->getPost("appliances"));
        }else{
            $appliances = 'None';
        }
        $result = $builder->insert([
            'user_id' => $user_id,
            'address' => $address,
            'home_size' => $home_size,
            'home_type' => $home_type,
            'own_solar_panel' => $solarpanel,
            'roof_pitch' => $roof_pitch,
            'roof_type' => $roof_type,
            'electric_bill' => $electric_bill,
            'appliances' => $appliances,
            'household_size' => $household,
            'future_household_size' => $household_size_next,
            'household_backup' => $backup,
            'know_more' => $know_more,
            'credit_score' => $creditscore,
            'date'  => date('Y-m-d')
        ]);
        $query = $user->getWhere(['id' => $user_id], 1);
        foreach ($query->getResult() as $row)
        {
            $name = $row->fname." ". $row->lname;
            $email = $row->email;
            $mobile = $row->phone;
            $referral = $row->referral;
        }

        if($referral==1){
            $referral = "yes";
        }else{
            $referral = "no";
        }

        $message="<h1>User Contacted</h1>";
        $message.="<h3>Your Name</h3>";
        $message.="<p>$name</p>";
        $message.="<hr>";

        $message.="<h3>Email</h3>";
        $message.="<p>$email</p>";
        $message.="<hr>";

        $message.="<h3>Phone</h3>";
        $message.="<p>$mobile</p>";
        $message.="<hr>";

        $message.="<h3>Referral</h3>";
        $message.="<p>$referral</p>";
        $message.="<hr>";

        $message.="<h3>Address</h3>";
        $message.="<p>$address</p>";
        $message.="<hr>";

        $message.="<h3>Home Size</h3>";
        $message.="<p>$home_size sq ft</p>";
        $message.="<hr>";

        $message.="<h3>Solar Panel</h3>";
        $message.="<p>$solartext</p>";
        $message.="<hr>";

        $message.="<h3>Roof Pitch</h3>";
        $message.="<p>$roof_pitch</p>";
        $message.="<hr>";

        $message.="<h3>Roof Type</h3>";
        $message.="<p>$roof_type</p>";
        $message.="<hr>";

        $message.="<h3>Electric Bill</h3>";
        $message.="<p>$electric_bill</p>";
        $message.="<hr>";

        $message.="<h3>Appliances</h3>";
        $message.="<p>$appliances</p>";
        $message.="<hr>";

        $message.="<h3>Household Size</h3>";
        $message.="<p>$household</p>";
        $message.="<hr>";

        $message.="<h3>Future Household Size</h3>";
        $message.="<p>$household_size_next</p>";
        $message.="<hr>";

        $message.="<h3>Household Backup</h3>";
        $message.="<p>$backup</p>";
        $message.="<hr>";

        $message.="<h3>Want to know more about</h3>";
        $message.="<p>$know_more</p>";
        $message.="<hr>";

        $message.="<h3>Credit Score</h3>";
        $message.="<p>$creditscore</p>";
        $message.="<hr>";
        // To send HTML mail, the Content-type header must be se
        $from = 'adtsolarpromailer@gmail.com';
        $subject = 'New User Registration';
        $to = 'support@adtsolarpro.com';
        
        $mail = new PHPMailer(true);

        try {
            //Server settings
            $mail->SMTPDebug = 1;                      //Enable verbose debug output
            $mail->isSMTP();                                            //Send using SMTP
            $mail->Host       = 'tls://smtp.gmail.com';                     //Set the SMTP server to send through
            $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
            $mail->Username   = 'adtsolarpromailer@gmail.com';                     //SMTP username
            $mail->Password   = 'adtmailer';                                //SMTP password
            $mail->SMTPSecure = 'ssl';          
            $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
        
            //Recipients
            $mail->setFrom($from, 'ADT Solar Pro');
            $mail->addAddress($to, 'nSmarTrac');     //Add a recipient
        
            //Content
            $mail->isHTML(true);                                  //Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body = $message;
        
            $mail->send();
            echo 'Message has been sent';
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
        return redirect()->to(base_url().'/thankyou?result=1');

    }
 
}
